<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Feria Laboral 2025</title>
<link rel="icon" href="images/favicon.ico" type="image/x-icon">

<!-- Bootstrap 5.3 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<!-- Estilos personalizados -->
<style>
  body {
    font-family: 'Roboto', sans-serif;
    background-color: #f8f9fa;
  }

  header {
    background: linear-gradient(135deg, #0d6efd, #2a9df4);
  }

  .navbar-brand {
    font-weight: 700;
    color: white !important;
  }

  .form-section {
    padding: 60px 15px;
  }

  .form-card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    background-color: #ffffff;
  }

  footer {
    background: #0d6efd;
    color: white;
    padding: 30px 0;
  }

  footer h6 {
    font-weight: 700;
  }

  footer p {
    margin-bottom: 0;
    font-size: 0.9rem;
  }

  .whatsapp-chat {
    position: fixed;
    bottom: 20px;
    right: 20px;
  }

  .whatsapp-chat a {
    background-color: #25d366;
    color: white;
    border-radius: 50%;
    padding: 14px 16px;
    font-size: 1.5rem;
    display: inline-block;
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    transition: all 0.3s;
  }

  .whatsapp-chat a:hover {
    transform: scale(1.1);
  }
</style>
</head>
<body>

<!-- Navbar -->
<header>
<nav class="navbar navbar-expand-lg navbar-dark container">
  <a class="navbar-brand d-flex align-items-center" href="#">
    <img src="images/unica2019.png" alt="UNICA" height="50" class="me-2">
    Dirección de Servicios Académicos
  </a>
  <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
    <span class="navbar-toggler-icon"></span>
  </button>

  <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
    <ul class="navbar-nav">
      <li class="nav-item"><a class="nav-link active" href="index.php">Inicio</a></li>
      <li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Inserción Laboral</a>
        <ul class="dropdown-menu">
          <li><a class="dropdown-item" href="https://bolsadetrabajo.unica.edu.pe/" target="_blank">Ingresar</a></li>
        </ul>
      </li>
      <li class="nav-item"><a class="nav-link" href="https://unica.edu.pe" target="_blank">Universidad</a></li>
    </ul>
  </div>
</nav>
</header>

<!-- Sección principal -->
<section class="form-section container">
  <div class="text-center mb-5">
    <h2 class="fw-bold text-primary">Registro de Participante</h2>
    <p class="text-muted">Complete el siguiente formulario para participar en la Feria Laboral 2025</p>
  </div>

  <div class="row align-items-center g-4">
    <div class="col-12 col-md-6 text-center">
      <img src="images/image-aviso.png" alt="Feria Laboral" class="img-fluid rounded shadow-sm">
    </div>

    <div class="col-12 col-md-6">
      <div class="card form-card p-4">
        <h4 class="mb-3 text-center text-primary">Formulario de Registro</h4>

        <form method="post" action="#">
          <div class="mb-3">
            <input type="text" name="dni" class="form-control" placeholder="DNI N°" required>
          </div>
          <div class="mb-3">
            <input type="text" name="apellidos" class="form-control" placeholder="Apellidos" required>
          </div>
          <div class="mb-3">
            <input type="text" name="nombres" class="form-control" placeholder="Nombres" required>
          </div>
          <div class="mb-3">
            <input type="text" name="celular" class="form-control" placeholder="Celular" required>
          </div>
          <div class="mb-3">
            <input type="email" name="correo" class="form-control" placeholder="Correo electrónico" required>
          </div>

          <?php
          include "combos/db.php";
          $db = connect();
          $query = $db->query("select * from facultades");
          $countries = array();
          while($r=$query->fetch_object()){ $countries[]=$r; }
          ?>

          <div class="mb-3">
            <select id="facultad" name="facultad" class="form-select" required>
              <option value="">Seleccione Facultad</option>
              <?php foreach($countries as $c):?>
              <option value="<?php echo $c->nomfacultad; ?>"><?php echo $c->nomfacultad; ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="mb-3">
            <select id="programa" name="programa" class="form-select" required>
              <option value="">Seleccione Programa de Estudios</option>
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label d-block">Condición</label>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="condicion" id="egresado" value="EGRESADO" required>
              <label class="form-check-label" for="egresado">Egresado</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="condicion" id="estudiante" value="ESTUDIANTE" required>
              <label class="form-check-label" for="estudiante">Estudiante</label>
            </div>
          </div>

          <div class="mb-3">
            <input type="text" id="egreso" name="egreso" class="form-control" placeholder="Año de egreso (Ej: 2017)" disabled>
          </div>

          <div class="mb-3">
            <input type="text" id="ciclo" name="ciclo" class="form-control" placeholder="Ciclo de estudios (Ej: VII)" disabled>
          </div>

          <div class="text-center">
            <button type="submit" name="btnRegistrar" class="btn btn-primary px-4">Registrar Datos</button>
          </div>
        </form>

        <?php
        if (isset($_POST['btnRegistrar'])){
          date_default_timezone_set('America/Lima');
          $dni = $_POST['dni'];
          $apellidos=$_POST['apellidos'];
          $nombres=$_POST['nombres'];
          $celular=$_POST['celular'];
          $correo=$_POST['correo'];
          $facultad=$_POST['facultad'];
          $programa=$_POST['programa'];
          $fecha=date('Y/m/d');
          $hora=date('g:i a');
          $condicion=$_POST['condicion'];
          $egreso=$_POST['egreso'];
          $ciclo=$_POST['ciclo'];
          require("cn/conexion.php");
          $insertar="INSERT INTO inscripcion2025(dni,apellidos,nombres,celular,correo,facultad,programa,fecha,hora,condicion,egreso,ciclo) 
                     VALUES('$dni','$apellidos','$nombres','$celular','$correo','$facultad','$programa','$fecha','$hora','$condicion','$egreso','$ciclo')";
          $resultado=mysqli_query($conexion,$insertar);
          if ($resultado) {
            echo "<script>
              Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: '✅ Sus datos han sido enviados exitosamente',
                showConfirmButton: false,
                timer: 3000
              });
              setTimeout(()=>window.location='https://serviciosacademicos.unica.edu.pe/ferialaboral2025/',3200);
            </script>";
          } else {
            echo "<script>
              Swal.fire({
                icon: 'error',
                title: 'Ocurrió un error',
                text: 'Por favor intente nuevamente o contacte con soporte.'
              });
            </script>";
          }
          mysqli_close($conexion);
        }
        ?>
      </div>
    </div>
  </div>
</section>

<!-- Footer -->
<footer class="text-center text-md-start">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-8 mb-3 mb-md-0 d-flex align-items-center">
        <img src="images/unica.png" alt="UNICA" height="50" class="me-2">
        <div>
          <h6>Dirección de Servicios Académicos</h6>
          <p>Biblioteca Sede Central – Ciudad Universitaria<br>
          Panamericana Sur Km 303<br>
          Correo: bolsadetrabajo@unica.edu.pe</p>
        </div>
      </div>
      <div class="col-md-4 text-center">
        <small>© 2025 Universidad Nacional San Luis Gonzaga</small>
      </div>
    </div>
  </div>
</footer>

<!-- Botón WhatsApp -->
<div class="whatsapp-chat">
  <a href="https://wa.me/51956956190" target="_blank" title="Chatea con nosotros por WhatsApp">
    <i class="bi bi-whatsapp"></i>
  </a>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<!-- Script de dependencias -->
<script>
document.addEventListener("DOMContentLoaded", () => {
  const egresado = document.getElementById('egresado');
  const estudiante = document.getElementById('estudiante');
  const egreso = document.getElementById('egreso');
  const ciclo = document.getElementById('ciclo');

  egresado.addEventListener('click', () => {
    egreso.disabled = false;
    ciclo.disabled = true;
    egreso.focus();
  });

  estudiante.addEventListener('click', () => {
    ciclo.disabled = false;
    egreso.disabled = true;
    ciclo.focus();
  });

  const facultad = document.getElementById("facultad");
  facultad.addEventListener("change", () => {
    fetch("combos/get_states.php?facultad=" + facultad.value)
      .then(response => response.text())
      .then(data => document.getElementById("programa").innerHTML = data);
  });
});
</script>

</body>
</html>
