<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Feria Laboral 2025</title>
<link href="images/favicon.ico" rel="shortcut icon" type="image/x-icon">

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Roboto&family=Cabin&family=Lato&display=swap" rel="stylesheet">

<!-- Bootstrap 5.3 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Estilos personalizados -->
<link rel="stylesheet" href="css/estilos.css">
<link rel="stylesheet" href="css/estilo-formulario.css">

<!-- FontAwesome y WhatsApp Plugin -->
<link rel="stylesheet" href="plugin/components/Font Awesome/css/font-awesome.min.css">
<link rel="stylesheet" href="plugin/whatsapp-chat-support.css">

<!-- Librerías JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
<header class="bg-primary">
  <nav class="navbar navbar-expand-lg navbar-dark container py-2">
    <a class="navbar-brand d-flex align-items-center" href="#">
      <img src="images/unica2019.png" alt="UNICA" class="me-2" height="50">
      <span>DIRECCIÓN DE SERVICIOS ACADÉMICOS</span>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMenu">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarMenu">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link active" href="index.php">Inicio</a></li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">Inserción Laboral</a>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="https://bolsadetrabajo.unica.edu.pe/" target="_blank">Ingresar</a></li>
          </ul>
        </li>
        <li class="nav-item"><a class="nav-link" href="https://unica.edu.pe" target="_blank">Universidad</a></li>
      </ul>
    </div>
  </nav>
</header>

<!-- Contenido principal -->
<section class="container my-5">
  <h4 class="display-6 text-center mb-4">Registro de Participante</h4>
  <p class="text-center text-muted">Estimado participante, registra tus datos para la Feria Laboral 2025.</p>

  <div class="row align-items-center mt-4">
    <div class="col-12 col-md-6 text-center mb-4 mb-md-0">
      <img src="images/image-aviso.png" alt="Aviso" class="img-fluid rounded shadow">
    </div>
    <div class="col-12 col-md-6">
      <!-- Formulario -->
      <form action="#" method="post" class="p-4 border rounded bg-light shadow-sm form-register">
        <h5 class="text-center mb-4">Formulario de Registro</h5>

        <div class="mb-3">
          <label for="dni" class="form-label">DNI</label>
          <input type="text" id="dni" name="dni" class="form-control" placeholder="Ingrese su DNI" required>
        </div>

        <div class="mb-3">
          <label for="apellidos" class="form-label">Apellidos</label>
          <input type="text" id="apellidos" name="apellidos" class="form-control" placeholder="Ingrese sus apellidos" required>
        </div>

        <div class="mb-3">
          <label for="nombres" class="form-label">Nombres</label>
          <input type="text" id="nombres" name="nombres" class="form-control" placeholder="Ingrese sus nombres" required>
        </div>

        <div class="mb-3">
          <label for="celular" class="form-label">Celular</label>
          <input type="text" id="celular" name="celular" class="form-control" placeholder="Ingrese su número de celular" required>
        </div>

        <div class="mb-3">
          <label for="correo" class="form-label">Correo electrónico</label>
          <input type="email" id="correo" name="correo" class="form-control" placeholder="Ingrese su correo" required>
        </div>

        <?php
        include "combos/db.php";
        $db = connect();
        $query = $db->query("SELECT * FROM facultades");
        $facultades = [];
        while($r = $query->fetch_object()) { $facultades[] = $r; }
        ?>

        <div class="mb-3">
          <label for="facultad" class="form-label">Facultad</label>
          <select id="facultad" name="facultad" class="form-select" required>
            <option value="">Seleccione una facultad</option>
            <?php foreach($facultades as $f): ?>
            <option value="<?php echo $f->nomfacultad; ?>"><?php echo $f->nomfacultad; ?></option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="mb-3">
          <label for="programa" class="form-label">Programa de Estudios</label>
          <select id="programa" name="programa" class="form-select" required>
            <option value="">Seleccione un programa</option>
          </select>
        </div>

        <script>
        $(document).ready(function(){
          $("#facultad").change(function(){
            $.get("combos/get_states.php", "facultad=" + $("#facultad").val(), function(data){
              $("#programa").html(data);
            });
          });
        });
        </script>

        <div class="mb-3">
          <label class="form-label d-block">Condición</label>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="condicion" id="egresado" value="EGRESADO" required>
            <label class="form-check-label" for="egresado">Egresado</label>
          </div>
          <div class="form-check form-check-inline">
            <input class="form-check-input" type="radio" name="condicion" id="estudiante" value="ESTUDIANTE" required>
            <label class="form-check-label" for="estudiante">Estudiante</label>
          </div>
        </div>

        <div class="mb-3">
          <input type="text" id="egreso" name="egreso" class="form-control" placeholder="Año de egreso (Ejemplo: 2020)" disabled>
        </div>

        <div class="mb-3">
          <input type="text" id="ciclo" name="ciclo" class="form-control" placeholder="Ciclo de estudios (Ejemplo: VII)" disabled>
        </div>

        <button type="submit" name="btnRegistrar" class="btn btn-primary w-100">Registrar Datos</button>

        <?php
        if (isset($_POST['btnRegistrar'])){
          date_default_timezone_set('America/Lima');
          require("cn/conexion.php");
          $dni = $_POST['dni'];
          $apellidos = $_POST['apellidos'];
          $nombres = $_POST['nombres'];
          $celular = $_POST['celular'];
          $correo = $_POST['correo'];
          $facultad = $_POST['facultad'];
          $programa = $_POST['programa'];
          $fecha = date('Y/m/d');
          $hora = date('g:i a');
          $condicion = $_POST['condicion'];
          $egreso = $_POST['egreso'];
          $ciclo = $_POST['ciclo'];

          $insertar = "INSERT INTO inscripcion2025(dni,apellidos,nombres,celular,correo,facultad,programa,fecha,hora,condicion,egreso,ciclo)
                       VALUES('$dni','$apellidos','$nombres','$celular','$correo','$facultad','$programa','$fecha','$hora','$condicion','$egreso','$ciclo')";
          $resultado = mysqli_query($conexion, $insertar);

          if ($resultado) {
            echo "<script>
              Swal.fire({
                toast: true,
                position: 'top-end',
                icon: 'success',
                title: '✅ Sus datos han sido enviados exitosamente',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true
              });
              setTimeout(()=> window.location='https://serviciosacademicos.unica.edu.pe/ferialaboral2025/', 3200);
            </script>";
          } else {
            echo "<script>
              Swal.fire({
                icon: 'error',
                title: 'Ocurrió un error desconocido',
                text: 'Por favor intente nuevamente o contacte con soporte.'
              });
            </script>";
          }
          mysqli_close($conexion);
        }
        ?>
      </form>
    </div>
  </div>
</section>

<footer class="bg-primary text-white py-4 mt-5">
  <div class="container text-center text-md-start">
    <div class="row">
      <div class="col-md-8 mb-3">
        <img src="images/unica.png" height="50" alt="UNICA">
        <h6 class="mt-2 fw-bold">Dirección de Servicios Académicos</h6>
      </div>
      <div class="col-md-4">
        <h6 class="fw-bold">Contáctenos</h6>
        <p class="mb-0 small">Biblioteca Sede Central<br>Panamericana Sur Km 303<br>
        <strong>Correo:</strong> bolsadetrabajo@unica.edu.pe</p>
      </div>
    </div>
    <hr class="border-light">
    <div class="text-center small">© 2025 Universidad Nacional San Luis Gonzaga</div>
  </div>
</footer>

<!-- Botón WhatsApp -->
<div class="whatsapp_chat_support wcs_fixed_right" id="button-w">
  <div class="wcs_button_label">Escríbenos por Whatsapp</div>  
  <div class="wcs_button wcs_button_circle">
    <span class="fa fa-whatsapp"></span>
  </div>  
  <div class="wcs_popup">
    <div class="wcs_popup_close"><span class="fa fa-close"></span></div>
    <div class="wcs_popup_header">
      <span class="fa fa-whatsapp"></span>
      <strong>Servicio al Graduado</strong>
      <div class="wcs_popup_header_description">¿Necesitas ayuda? Chatea con nosotros en WhatsApp</div>
    </div>  
    <div class="wcs_popup_input" 
      data-number="51956956190"
      data-availability='{ "monday":"07:00-22:30", "tuesday":"07:00-22:30", "wednesday":"07:30-22:30", "thursday":"07:00-22:30", "friday":"07:00-22:30", "saturday":"09:00-18:30", "sunday":"09:00-22:30" }'>
      <input type="text" placeholder="Escribir pregunta!">
      <i class="fa fa-play"></i>
    </div>
    <div class="wcs_popup_avatar">
      <img src="images/unica.png" alt="">
    </div>
  </div>
</div>

<!-- Plugins -->
<script src="plugin/components/moment/moment.min.js"></script>
<script src="plugin/components/moment/moment-timezone-with-data.min.js"></script>
<script src="plugin/whatsapp-chat-support.js"></script>

<script>
$('#button-w').whatsappChatSupport({ defaultMsg: '' });

$('#egresado').on('change', function() {
  $('#egreso').prop('disabled', false).focus();
  $('#ciclo').prop('disabled', true).val('');
});
$('#estudiante').on('change', function() {
  $('#ciclo').prop('disabled', false).focus();
  $('#egreso').prop('disabled', true).val('');
});
</script>
</body>
</html>
