<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Registrar Asistencia - Feria Laboral UNICA 2024</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<style>
body { background-color: #f9f9f9; font-family: 'Segoe UI', sans-serif; }
header { background: #060166; color: #fff; text-align:center; padding:1.5em; }
h2, h3 { margin: 0.3em 0; }
.btn-primary { background: crimson; border: none; }
</style>
</head>
<body>
<header>
  <img src="images/image-logo-ogasa.png" alt="UNICA" style="max-height:70px;">
  <h2>Feria Laboral - UNICA 2024</h2>
  <h3>Martes 03 de Diciembre | 09:00 am – 02:00 pm</h3>
</header>
<main class="container my-4">
  <p class="text-center">Por favor, digite correctamente el DNI del participante.</p>
  <div class="text-center mb-3">
    <a class="btn btn-secondary" href="https://serviciosacademicos.unica.edu.pe/ferialaboral2024/" target="_blank">Nuevo Participante</a>
  </div>
  <form action="guardar.php" method="post" class="col-md-6 mx-auto bg-white p-4 rounded shadow-sm">
    <div class="mb-3">
      <label class="form-label">DNI</label>
      <input type="text" name="dni" id="dni" class="form-control" placeholder="DNI" maxlength="8" required>
    </div>
    <div class="mb-3"><input type="text" name="apellidos" id="apellidos" class="form-control" placeholder="Apellidos" required></div>
    <div class="mb-3"><input type="text" name="nombres" id="nombres" class="form-control" placeholder="Nombres" required></div>
    <div class="mb-3"><input type="text" name="celular" id="celular" class="form-control" placeholder="Celular"></div>
    <div class="mb-3"><input type="email" name="correo" id="correo" class="form-control" placeholder="Correo"></div>
    <div class="mb-3"><input type="text" name="facultad" id="facultad" class="form-control" placeholder="Facultad"></div>
    <div class="mb-3"><input type="text" name="programa" id="programa" class="form-control" placeholder="Programa"></div>
    <div class="mb-3"><input type="text" name="condicion" id="condicion" class="form-control" placeholder="Condición"></div>
    <div class="mb-3"><input type="text" name="egreso" id="egreso" class="form-control" placeholder="Año de egreso"></div>
    <div class="mb-3"><input type="text" name="ciclo" id="ciclo" class="form-control" placeholder="Ciclo de estudios"></div>
    <button type="submit" class="btn btn-primary w-100">Registrar Asistencia</button>
  </form>
</main>
<script>
$(document).ready(function(){
  $('#dni').on('blur', function(){
    let dni = $(this).val().trim();
    if(dni.length === 8){
      $.post('busca_dni.php', { valorBusqueda: dni }, function(res){
        if(res.dato === 1){
          $('#apellidos').val(res.apellidos);
          $('#nombres').val(res.nombres);
          $('#celular').val(res.celular);
          $('#correo').val(res.correo);
          $('#facultad').val(res.facultad);
          $('#programa').val(res.programa);
          $('#condicion').val(res.condicion);
          $('#egreso').val(res.egreso);
          $('#ciclo').val(res.ciclo);
          alert('✅ Participante encontrado: ' + res.nombres + ' ' + res.apellidos);
        } else {
          alert(res.alerta);
        }
      }, 'json');
    }
  });
  $('form').on('submit', function(){
    $('button[type=submit]').prop('disabled', true).text('Registrando...');
  });
});
</script>
</body>
</html>
