<?php
date_default_timezone_set('America/Lima');
require_once("cone/conexion.php");
header('Content-Type: text/html; charset=utf-8');

$dni       = trim($_POST['dni'] ?? '');
$apellidos = trim($_POST['apellidos'] ?? '');
$nombres   = trim($_POST['nombres'] ?? '');
$celular   = trim($_POST['celular'] ?? '');
$correo    = trim($_POST['correo'] ?? '');
$facultad  = trim($_POST['facultad'] ?? '');
$programa  = trim($_POST['programa'] ?? '');
$condicion = trim($_POST['condicion'] ?? '');
$egreso    = trim($_POST['egreso'] ?? '');
$ciclo     = trim($_POST['ciclo'] ?? '');
$fecha     = date('Y-m-d');
$hora      = date('H:i:s');

if ($dni === '' || $nombres === '' || $apellidos === '') {
    die("<h3>Error: DNI, nombres y apellidos son obligatorios.</h3>");
}

$sql = "INSERT INTO asistencia2024 
        (dni, apellidos, nombres, celular, correo, facultad, programa, fecha, hora, condicion, egreso, ciclo) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $con->prepare($sql);

if (!$stmt) {
    die("<h3>Error en la preparación de la consulta: " . $con->error . "</h3>");
}

$stmt->bind_param(
    "ssssssssssss",
    $dni,
    $apellidos,
    $nombres,
    $celular,
    $correo,
    $facultad,
    $programa,
    $fecha,
    $hora,
    $condicion,
    $egreso,
    $ciclo
);

if ($stmt->execute()) {
    echo "<div style='text-align:center; margin-top:50px; font-family:sans-serif;'>
            <h2 style='color:green;'>✅ Asistencia registrada exitosamente</h2>
            <a href='index.php' class='btn btn-primary'>Registrar otro participante</a>
          </div>";
} else {
    echo "<h3>Error al registrar la asistencia: " . htmlspecialchars($stmt->error) . "</h3>";
}

$stmt->close();
$con->close();
?>
