<?php
require_once("cone/conexion.php");
header('Content-Type: application/json; charset=utf-8');

if (!isset($_POST['valorBusqueda']) || empty(trim($_POST['valorBusqueda']))) {
    echo json_encode(["error" => "No se recibió el parámetro de búsqueda."]);
    exit;
}

$dni = trim($_POST['valorBusqueda']);

$stmt = $con->prepare("SELECT * FROM inscripcion2024 WHERE dni = ?");
$stmt->bind_param("s", $dni);
$stmt->execute();
$result = $stmt->get_result();

$objeto = new stdClass();

if ($result->num_rows === 0) {
    $objeto->dato = 0;
    $objeto->alerta = "DNI N° $dni no hallado. Debe registrarse para acceder al evento.";
} else {
    $fila = $result->fetch_assoc();
    $objeto->dato = 1;
    $objeto->alerta = "Participante encontrado.";
    foreach ($fila as $key => $value) {
        $objeto->$key = $value;
    }
}

echo json_encode($objeto, JSON_UNESCAPED_UNICODE);

$stmt->close();
$con->close();
?>
